require("dotenv").config();

const express = require("express");
const cors = require("cors");
const fs = require("fs");
const path = require("path");
const https = require("https");
const enquiryRouter = require("./router/router.js")




const app = express();
app.use(express.json());


const options = {
  cert: fs.readFileSync(path.resolve(__dirname, 'secure.crt')),
  key: fs.readFileSync(path.resolve(__dirname, 'secure.key')),
};



const allowedOrigins = [
  "https://ftvrealestate.in",
  "https://www.ftvrealestate.in"
];

const corsOptions =
  process.env.NODE_ENV === "production"
    ? {
        origin: function (origin, callback) {
          // Allow requests with no origin (like mobile apps, curl, etc.)
          if (!origin) return callback(null, true);
          if (allowedOrigins.includes(origin)) {
            return callback(null, true);
          } else {
            return callback(new Error("Not allowed by CORS"));
          }
        },
        methods: "GET,POST",
        credentials: true,
      }
    : {
        origin: "*",
      };

app.use(cors(corsOptions));



app.use("/v1/api", enquiryRouter);
app.use("/download", express.static(path.join(__dirname, "public/assets")));

const PORT = process.env.PORT || 3200 

// const server = https.createServer(options, app);

// server.listen(PORT, () => {
//   console.log(`Server is listening at port ${PORT}`);
// });

app.listen(PORT, () => {
    console.log(`Server is Listening at ${PORT}`);
})
app.get("/", (req, res) => {
  res.send("Welcome to the node project");
});