const db = require("../config/db.js");
const nodemailer = require("nodemailer");

const transporter = nodemailer.createTransport({
  // host: "smtp.gmail.com",
  host: "smtp.gmail.com",
  port: 587,
  secureConnection: true,
  auth: {
    user: "business@ftv.ind.in",
    pass: "bohjspazpvctxhmu",
  },
  tls: {
    rejectUnauthorized: false,
  },
});

module.exports = {
  user: (data, callBack) => {
    db.query(
      `insert into auth(name,email,password,status)values(?,?,?,?)`,
      [data.name, data.email, data.password, data.status],
      (error, results, fields) => {
        if (error) {
          return callBack(error);
        }
        return callBack(null, results);
      }
    );
  },

create: (data, callBack) => {
  const now = new Date();

  const sql = `
    INSERT INTO realestate_landing_enquiry (
      fullname, email, contact, vertical_categoty, vertical_name, developer_name,
      project, state, city, message, created_at, updated_at
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
      updated_at = VALUES(updated_at)
  `;

  const values = [
    data.name,
    data.email,
    data.contact,
    data.verticalCategory,
    data.verticalName,
    data.developerName,
    data.projectNumber,
    data.state,
    data.city,
    data.message,
    now,
    now,
  ];

  db.query(sql, values, (error, results) => {
    if (error) {
      console.error("Database insertion error:", error);
      return callBack({
        message: error.code === "ER_DUP_ENTRY"
          ? "Duplicate contact, updated timestamp."
          : "Error occurred while inserting or updating user.",
      });
    }
    return callBack(null, results);
  });
},


  getUserByUserEmail: (email, callBack) => {
    db.query(
      `SELECT * FROM auth where email = ?`,
      [email],
      (error, results, fields) => {
        if (error) {
          callBack(error);
        }
        return callBack(null, results[0]);
      }
    );
  },

contact: (data, callBack) => {
  const now = new Date();

  const sql = `
    INSERT INTO fbar_landing_enquiry (
      fullname, email, mobile, tier_type, investment, state, city, message, created_at, updated_at
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
      updated_at = VALUES(updated_at)
  `;

  const values = [
    data.fullname,
    data.email,
    data.mobile,
    data.tier_type,
    data.investment,
    data.state,
    data.city,
    data.message,
    now,   // created_at
    now    // updated_at
  ];

  db.query(sql, values, (error, results) => {
    if (error) {
      console.error("Insert/Update error:", error);
      return callBack(error);
    }
    return callBack(null, results);
  });
},


  checkIfEmailExists: (subscribe_email, callBack) => {
    db.query(
      `SELECT * FROM brocher_subscribe where email = ?`,
      [subscribe_email],
      (error, results, fields) => {
        if (error) {
          callBack(error);
        }
        return callBack(null, results);
      }
    );
  },

  addNewSubscriber: (data, callBack) => {
    const query = `
    INSERT INTO brocher_subscribe (email, source, created_at, updated_at)
VALUES (?, ?, ?, ?)
ON DUPLICATE KEY UPDATE
  source = VALUES(source),
  updated_at = VALUES(updated_at)
  `;
    const now = new Date();

    db.query(
      query,
      [data.email, data.source, now, now],
      (error, results, fields) => {
        if (error) {
          return callBack(error);
        }
        return callBack(null, results);
      }
    );
  },

  sandWelcomeEmail: (email, callBack) => {
    const mailOptions = {
      from: "business@ftv.ind.in",
      to: email,
      subject: "Welcome to Our Newsletter!",
      text: "Thank you for subscribing to our newsletter. We are excited to have you on board!",
    };

    transporter.sendMail(mailOptions, (error, info) => {
      if (error) {
        console.error("Error sending email:", error);
        callBack(error, null);
      } else {
        console.log("Email sent:", info.response);
        callBack(null, true);
      }
    });
  },

  sendBrocherEmail: (email, downloadLink, callBack) => {
    const mailOptions = {
      from: "business@ftv.ind.in",
      to: email,
      subject: "Your Secure Brochure Download Link",
      text: `Hello,

      Please use the following secure link to download the brochure:
          
      ${downloadLink}
          
      This link will expire in 1 hour.
          
      Best regards,
      F Real Estate Team`,
    };
    transporter.sendMail(mailOptions, (error, info) => {
    if (error) {
        console.error("Error sending email:", error);
        callBack(error, null);
      } else {
        console.log("Email sent:", info.response);
        callBack(null, true);
      }
    });
  },
};
